<?php

namespace IZON\IO\Tests;

use IZON\IO\RasterImage;
use PHPUnit\Framework\TestCase;

/**
 * @covers \IZON\IO\RasterImage
 */
class RasterImageTest extends TestCase
{
    public function testCreate(): void
    {
        $rasterImage = new RasterImage(__DIR__ . '/test-img.png');

        $this->assertEquals('test-img.png', $rasterImage->getFileName());
    }

    public function testMetaData(): void
    {
        $rasterImage = new RasterImage(__DIR__ . '/test-img.png');

        $this->assertEquals(225, $rasterImage->getPixelWidth());
        $this->assertEquals(200, $rasterImage->getPixelHeight());
        $this->assertEquals('image/png', $rasterImage->getMimeType());

        // TODO: exif rotated file test
    }
}
