<?php

namespace IZON\Utils\Tests;

use InvalidArgumentException;
use IZON\Utils\PasswordUtils;
use PHPUnit\Framework\TestCase;

/**
 * @covers \IZON\Utils\PasswordUtils
 */
class PasswordUtilsTest extends TestCase
{
    public function testLength(): void
    {
        $password = PasswordUtils::generatePassword();
        $this->assertEquals(16, strlen($password));

        for($i = PasswordUtils::MIN_PASSWORD_LENGTH; $i < 30; $i++) {
            $password = PasswordUtils::generatePassword($i);
            $this->assertEquals($i, strlen($password));
        }

        $this->expectException(InvalidArgumentException::class);
        PasswordUtils::generatePassword(PasswordUtils::MIN_PASSWORD_LENGTH-1);
    }

    public function testAllowedChars(): void
    {
        $this->expectException(InvalidArgumentException::class);
        PasswordUtils::generatePassword(16, 0);
    }
}
