<?php

namespace IZON\Utils\Tests;

use IZON\Utils\ObjectUtils;
use IZON\Utils\TestHelpers\DestObject;
use IZON\Utils\TestHelpers\OrigObject;
use PHPUnit\Framework\TestCase;
use ReflectionClass;
/**
 * @covers \IZON\Utils\ObjectUtils
 */
class ObjectUtilsTest extends TestCase
{
    public function testToArray(): void
    {
        $orig = new OrigObject();
        $orig->setInt(1);
        $orig->setString('test');

        $refClass = new ReflectionClass($orig);
        $refClass->getProperty('protectedSetter')
            ->setValue($orig, 'protectedSetter');

        $array = ObjectUtils::toArray(
            $orig,
            ['copyProperty']
        );

        $this->assertEquals(
            [
                'int' => 1,
                'string' => 'test',
                'protectedSetter' => 'protectedSetter'
            ],
            $array
        );

        $protectedGetterProperty = $refClass->getProperty('protectedGetter');
        $this->assertFalse($protectedGetterProperty->isInitialized($orig));

        $protectedGetterSetterProperty = $refClass->getProperty('protectedGetterSetter');
        $this->assertFalse($protectedGetterSetterProperty->isInitialized($orig));
    }

    public function testFromArray(): void
    {
        $dest = new OrigObject();
        $refClass = new ReflectionClass($dest);

        ObjectUtils::fromArray(
            $dest,
            [
                'int' => 1,
                'string' => 'test',
                'protectedGetter' => 'protectedGetter',
                'copyProperty' => 'copyProperty'
            ],
            ['copyProperty']
        );

        $this->assertEquals(1, $dest->getInt());
        $this->assertEquals('test', $dest->getString());

        $protectedGetterProperty = $refClass->getProperty('protectedGetter');
        $this->assertEquals('protectedGetter', $protectedGetterProperty->getValue($dest));

        $protectedSetterProperty = $refClass->getProperty('protectedSetter');
        $this->assertFalse($protectedSetterProperty->isInitialized($dest));

        $protectedGetterSetterProperty = $refClass->getProperty('protectedGetterSetter');
        $this->assertFalse($protectedGetterSetterProperty->isInitialized($dest));

        $copyProperty = $refClass->getProperty('copyProperty');
        $this->assertFalse($copyProperty->isInitialized($dest));
    }

    public function testCopyProperties(): void
    {
        $orig = new OrigObject();
        $orig->setInt(1);
        $orig->setString('test');

        $origRefClass = new ReflectionClass($orig);
        $origRefClass->getProperty('protectedSetter')
            ->setValue($orig, 'protectedSetter');
        $origRefClass->getProperty('protectedGetter')
            ->setValue($orig, 'protectedGetter');
        $origRefClass->getProperty('protectedGetterSetter')
            ->setValue($orig, 'protectedGetterSetter');
        $origRefClass->getProperty('copyProperty')
            ->setValue($orig, 'copyProperty');

        $dest = new DestObject();
        $destRefClass = new ReflectionClass($dest);

        ObjectUtils::copyProperties($dest, $orig);

        $this->assertEquals(1, $dest->getInt());
        $this->assertEquals('test', $dest->getString());

        $protectedGetterProperty = $destRefClass->getProperty('protectedGetter');
        $this->assertFalse($protectedGetterProperty->isInitialized($dest));

        $protectedSetterProperty = $destRefClass->getProperty('protectedSetter');
        $this->assertFalse($protectedSetterProperty->isInitialized($dest));

        $protectedGetterSetterProperty = $destRefClass->getProperty('protectedGetterSetter');
        $this->assertFalse($protectedGetterSetterProperty->isInitialized($dest));

        $copyProperty = $destRefClass->getProperty('copyProperty');
        $this->assertEquals('copyProperty', $copyProperty->getValue($dest));
    }
}
