<?php

namespace IZON\Locale\Tests;

use IZON\Locale\Locale;
use PHPUnit\Framework\TestCase;

/**
 * @covers \IZON\Locale\Locale
 */
class LocaleTest extends TestCase
{
    public function testFromLocaleTag(): void
    {
        $locale = Locale::fromLocaleTag("en");
        $this->assertEquals("en", $locale->getLanguage());
        $this->assertNull($locale->getRegion());
        $this->assertNull($locale->getScript());

        $locale = Locale::fromLocaleTag("en-US");
        $this->assertEquals("en", $locale->getLanguage());
        $this->assertEquals("US", $locale->getRegion());
        $this->assertNull($locale->getScript());
    }
}
