<?php

namespace IZON\IO\Tests;

use IZON\IO\TempFile;
use PHPUnit\Framework\TestCase;

/**
 * @covers \IZON\IO\TempFile
 */
class TempFileTest extends TestCase
{
    public function testTMPFile(): void
    {
        $tmp = new TempFile('temp.txt');
        $tmp->write("Foo");
        $this->assertEquals('Foo', $tmp->getFileContents());
    }

    public function testTwoTMPFiles(): void
    {
        $tmp = new TempFile('temp.txt');
        $tmp->write("Foo");
        $tmp2 = new TempFile('temp2.txt');
        $tmp2->write("Bar");
        $this->assertEquals('Foo', $tmp->getFileContents());
        $this->assertEquals('Bar', $tmp2->getFileContents());
    }
}
