<?php

namespace IZON\IO\Tests;

use IZON\IO\File;

use PHPUnit\Framework\TestCase;

/**
 * @covers \IZON\IO\File
 */
class FileTest extends TestCase
{
    public function testCreateFile(): void
    {
        $thisClassFile = __DIR__ . "/FileTest.php";
        $file = new File($thisClassFile);
        $this->assertTrue(true);
    }

    public function testFileExists(): void
    {
        $thisClassFile = __DIR__ . "/FileTest.php";

        $file = new File($thisClassFile);
        $this->assertEquals(true, $file->exists());

        $file = new File("asasw");
        $this->assertEquals(false, $file->exists());
    }

    public function testIsFile(): void
    {
        $thisClassFile = __DIR__ . "/FileTest.php";

        $file = new File($thisClassFile);
        $this->assertEquals(true, $file->isFile());

        $file = new File(__DIR__);
        $this->assertEquals(false, $file->isFile());
    }

    public function testIsDir(): void
    {
        $thisClassFile = __DIR__ . "/FileTest.php";

        $file = new File($thisClassFile);
        $this->assertEquals(false, $file->isDir());

        $file = new File(__DIR__);
        $this->assertEquals(true, $file->isDir());
    }

    public function testGetMimeType(): void
    {
        $thisClassFile = __DIR__ . "/FileTest.php";

        $file = new File($thisClassFile);
        $this->assertEquals("text/x-php", $file->getMimeType());
    }

    public function testGetFileContent(): void
    {
        $thisClassFile = __DIR__ . "/FileTest.php";
        $file = new File($thisClassFile);

        $this->assertEquals(file_get_contents($thisClassFile), $file->getFileContents());
    }
}
