<?php

namespace IZON\Utils;

use IZON\Utils\Exceptions\JsonDecodeException;
use IZON\Utils\Exceptions\JsonEncodeException;

/**
 * utility functions for Json
 * @package IZON\Utils
 */
class JsonUtils
{
    /**
     * @param mixed $value value to encode to json
     * @param int $flags same as in https://www.php.net/manual/en/function.json-encode.php
     * @param int $depth max depth to encode $value
     * @return string encoded to JSON format
     */
    public static function encode(mixed $value, int $flags = 0, int $depth = 512): string
    {
        if ($depth <= 0) {
            throw new JsonEncodeException('Depth must be greater than zero');
        }
        $json = json_encode($value, $flags, $depth);
        if ($json === false) {
            $error = json_last_error();
            throw new JsonEncodeException(json_last_error_msg(), $error);
        }

        return $json;
    }


    /**
     * @param string $json json string
     * @param int $flags same as in https://www.php.net/manual/en/function.json-decode.php
     * @param int $depth max depth to decode $json
     * @return mixed
     */
    public static function decode(string $json, int $flags = 0, int $depth = 512): mixed
    {
        if ($depth <= 0) {
            throw new JsonDecodeException('Depth must be greater than zero');
        }
        $value = json_decode($json, null, $depth, $flags);
        if (JSON_ERROR_NONE !== $error = json_last_error()) {
            throw new JsonDecodeException(json_last_error_msg(), $error);
        }

        return $value;
    }
}
