<?php

namespace IZON\IO;

use IZON\IO\Exceptions\FilesystemAccessException;
use IZON\IO\Exceptions\UnsupportedRasterImageTypeException;
use Serializable;

class TempRasterImage extends TempFile implements RasterImageInterface, Serializable
{
    protected bool $initialized = false;

    protected int $width;

    protected int $height;

    protected int $imageType;


    /**
     * {@inheritDoc}
     */
    public function getPixelWidth(): int
    {
        $this->initImageInfo();
        return $this->width;
    }

    /**
     * {@inheritDoc}
     */
    public function getPixelHeight(): int
    {
        $this->initImageInfo();
        return $this->height;
    }

    /**
     * {@inheritDoc}
     */
    public function getType(): int
    {
        $this->initImageInfo();
        return $this->imageType;
    }


    /**
     * provede initializes image info
     * @throws UnsupportedRasterImageTypeException
     * @throws FilesystemAccessException
     */
    protected function initImageInfo(): void
    {
        if (!$this->initialized) {
            $imageSize = getimagesizefromstring($this->getFileContents());
            if ($imageSize === false) {
                throw new UnsupportedRasterImageTypeException("File " . $this->file->getRealPath() . " is not image");
            }

            $this->width = $imageSize[0];
            $this->height = $imageSize[1];
            $this->imageType = $imageSize[2];

            $exif = @exif_read_data($this->file->getRealPath()) ?: [];
            if (!empty($exif['Orientation']) && in_array($exif['Orientation'], [6, 8])) {
                $this->width = $imageSize[1];
                $this->height = $imageSize[0];
            }
        }
    }
}
