<?php

namespace IZON\IO;

use IZON\IO\Exceptions\FilesystemAccessException;
use IZON\IO\Exceptions\UnsupportedRasterImageTypeException;

/**
 * raster image interface
 */
interface RasterImageInterface extends ImageInterface
{
    /**
     * @return int pixel width of image will be displayed in browsers or image viewers
     * applies EXIF image orientation or other transformations that result in different size in browsers or image viewers
     * @throws UnsupportedRasterImageTypeException
     * @throws FilesystemAccessException
     */
    public function getPixelWidth(): int;

    /**
     * @return int pixel height of image will be displayed in browsers or image viewers
     * applies EXIF image orientation or other transformations that result in different size in browsers or image viewers
     * @throws UnsupportedRasterImageTypeException
     * @throws FilesystemAccessException
     */
    public function getPixelHeight(): int;
}
