<?php

namespace IZON\App\ECSConfig;

use PhpCsFixer\Fixer\ClassNotation\ProtectedToPrivateFixer;
use Symplify\EasyCodingStandard\Config\ECSConfig;
use Symplify\EasyCodingStandard\ValueObject\Option;
use Symplify\EasyCodingStandard\ValueObject\Set\SetList;

return static function (ECSConfig $containerConfigurator): void {
    $containerConfigurator->import(SetList::PSR_12);
    $containerConfigurator->import(SetList::CLEAN_CODE);

    $services = $containerConfigurator->services();
    $services->remove(ProtectedToPrivateFixer::class); // @phpstan-ignore-line - fixer might not be present

    $containerConfigurator->paths(
        [
            __DIR__ . '/src',
        ]
    );

    $parameters = $containerConfigurator->parameters();
    $parameters->set(Option::PARALLEL, false);
};
