<?php

namespace IZON\Utils\Tests;

use IZON\Utils\JsonUtils;
use PHPUnit\Framework\TestCase;

class JsonUtilsTest extends TestCase
{
    public function testEncode(): void
    {
        $array = ['name' => 'blah', 'surname' => 'bleh', 'age' => 22];
        $this->assertEquals('{"name":"blah","surname":"bleh","age":22}', JsonUtils::encode($array));
    }

    public function testEncodeWrong(): void
    {
        $array = ['name' => 'blah', 'surname' => 'bleh', 'age' => 22];
        $this->assertNotEquals('{"name":"blah"}', JsonUtils::encode($array));
    }

    public function testDecode(): void
    {
        $json = '{"name":"blah","surname":"bleh","age":22}';
        $stdClass = JsonUtils::decode($json);
        $this->assertEquals('blah', $stdClass->name);
        $this->assertEquals('bleh', $stdClass->surname);
        $this->assertEquals('22', $stdClass->age);
    }

    public function testDecodeWrong(): void
    {
        $json = '{"name":"blah","surname":"bleh","age":22}';
        $stdClass = JsonUtils::decode($json);
        $this->assertNotEquals('flah', $stdClass->name);
        $this->assertObjectNotHasProperty('firstName', $stdClass);
    }
}
