<?php

namespace IZON\Utils\Tests;

use IZON\Utils\ArrayUtils;
use IZON\Utils\TestHelpers\IntCollection;
use PHPUnit\Framework\TestCase;

class ArrayUtilsTest extends TestCase
{
    public function testToArray(): void
    {
        include_once __DIR__ . '/../TestHelpers/IntCollection.php';

        $collection = new IntCollection([1, 2, 3]);

        $this->assertEquals([1, 2, 3], ArrayUtils::toArray($collection));
    }

    public function testCreateHashSet(): void
    {
        $items = [['id' => 1, 'name' => 'Blah'], ['id' => 2, 'name' => 'Bleh'], ['id' => 3, 'name' => 'Bluh']];
        $hashSet = ArrayUtils::createHashMap($items, fn (array $item): string => 'id:' . $item['id']);

        $this->assertEquals(
            [
                'id:1' => ['id' => 1, 'name' => 'Blah'],
                'id:2' => ['id' => 2, 'name' => 'Bleh'],
                'id:3' => ['id' => 3, 'name' => 'Bluh']
            ],
            $hashSet
        );
    }

    public function testCreateHashMap(): void
    {
        $items = [['id' => 1, 'name' => 'Blah'], ['id' => 2, 'name' => 'Bleh'], ['id' => 3, 'name' => 'Bluh']];
        $hashMap = ArrayUtils::createHashMap($items, fn (array $item): string => 'id:' . $item['id']);

        $this->assertEquals(
            [
                'id:1' => ['id' => 1, 'name' => 'Blah'],
                'id:2' => ['id' => 2, 'name' => 'Bleh'],
                'id:3' => ['id' => 3, 'name' => 'Bluh']
            ],
            $hashMap
        );
    }

    public function testIsEmpty(): void
    {
        $this->assertTrue(ArrayUtils::isEmpty([]));
    }

    public function testIsEmptyWrong(): void
    {
        $this->assertTrue(!ArrayUtils::isEmpty([1, 2, 3]));
    }

    public function testLength(): void
    {
        $this->assertEquals(3, ArrayUtils::length([1, 2, 3]));
    }

    public function testLengthWrong(): void
    {
        $this->assertNotEquals(2, ArrayUtils::length([1, 2, 3]));
    }

    public function testFirst(): void
    {
        $this->assertEquals(1, ArrayUtils::first([1, 2, 3]));
    }

    public function testFirstWrong(): void
    {
        $this->assertNotEquals(2, ArrayUtils::first([1, 2, 3]));
    }

    public function testLast(): void
    {
        $this->assertEquals(3, ArrayUtils::last([1, 2, 3]));
    }

    public function testLastWrong(): void
    {
        $this->assertNotEquals(2, ArrayUtils::last([1, 2, 3]));
    }

    public function testEvery(): void
    {
        $items = [
            ['id' => 1, 'name' => 'Blah', 'age' => 22],
            ['id' => 2, 'name' => 'Bleh', 'age' => 25],
            ['id' => 3, 'name' => 'Bluh', 'age' => 33]
        ];

        $fnc = function (array $item): bool {
            return $item['age'] > 20;
        };

        $this->assertTrue(ArrayUtils::every($items, $fnc));
    }

    public function testEveryWrong(): void
    {
        $items = [
            ['id' => 1, 'name' => 'Blah', 'age' => 22],
            ['id' => 2, 'name' => 'Bleh', 'age' => 25],
            ['id' => 3, 'name' => 'Bluh', 'age' => 33]
        ];

        $fnc = function (array $item): bool {
            return $item['age'] > 25;
        };

        $this->assertTrue(!ArrayUtils::every($items, $fnc));
    }
}
