<?php

namespace IZON\Utils\TestHelpers;

use ArrayAccess;
use Countable;
use Iterator;

/**
 * @implements Iterator<array-key, int>
 * @implements ArrayAccess<array-key, int>
 */
class IntCollection implements Countable, Iterator, ArrayAccess
{
    /** @var array<int, int> */
    private array $values = [];

    private int $position = 0;


    /**
     * @param array<int, int> $values
     */
    public function __construct(array $values = [])
    {
        foreach ($values as $value) {
            $this->offsetSet('', $value);
        }
    }

    public function count(): int
    {
        return count($this->values);
    }

    public function rewind(): void
    {
        $this->position = 0;
    }

    public function key(): mixed
    {
        return $this->position;
    }

    public function current(): mixed
    {
        return $this->values[$this->position];
    }

    public function next(): void
    {
        $this->position++;
    }

    public function valid(): bool
    {
        return isset($this->values[$this->position]);
    }

    public function offsetExists($offset): bool
    {
        return isset($this->values[$offset]);
    }

    public function offsetGet($offset): mixed
    {
        return $this->values[$offset];
    }

    public function offsetSet($offset, $value): void
    {
        if (!is_int($value)) {
            throw new \InvalidArgumentException("Must be an int");
        }

        if (empty($offset)) { //this happens when you do $collection[] = 1;
            $this->values[] = $value;
        } else {
            $this->values[$offset] = $value; // @phpstan-ignore-line
        }
    }

    public function offsetUnset($offset): void
    {
        unset($this->values[$offset]);
    }
}
