<?php

namespace IZON\IO\Tests;

use IZON\IO\TempFile;
use IZON\IO\TempRasterImage;
use PHPUnit\Framework\TestCase;

/**
 * @covers \IZON\IO\TempRasterImage
 */
class TempRasterImageTest extends TestCase
{
    public function testCreateAndWrite(): void
    {
        $tmp = new TempRasterImage('temp.png');

        $fileContents = file_get_contents(__DIR__ . '/test-img.png');
        if ($fileContents === false) {
            $this->fail('Could not read test image');
        }
        $tmp->write($fileContents);
        $this->assertEquals($fileContents, $tmp->getFileContents());
    }

    public function testTwoTMPFiles(): void
    {
        $tmp = new TempFile('temp.txt');
        $tmp->write("Foo");
        $tmp2 = new TempFile('temp2.txt');
        $tmp2->write("Bar");
        $this->assertEquals('Foo', $tmp->getFileContents());
        $this->assertEquals('Bar', $tmp2->getFileContents());
    }

    public function testMetaData(): void
    {
        $tmp = new TempRasterImage('temp.png');

        $fileContents = file_get_contents(__DIR__ . '/test-img.png');
        if ($fileContents === false) {
            $this->fail('Could not read test image');
        }
        $tmp->write($fileContents);

        $this->assertEquals(225, $tmp->getPixelWidth());
        $this->assertEquals(200, $tmp->getPixelHeight());
    }
}
