<?php


namespace IZON\Utils;

use InvalidArgumentException;

/**
 * utility functions for arrays
 * @package IZON\Utils
 */
class ArrayUtils
{
    /**
     * if iterable is not array extracts elements from iterable to array or returns original array otherwise
     * @template T
     * @param iterable<T> $iterable
     * @return array<T>
     */
    public static function toArray(iterable $iterable): array
    {
        if (is_array($iterable)) {
            return $iterable;
        }
        return iterator_to_array($iterable);
    }

    /**
     * @deprecated use ArrayUtils::createHashMap
     * Returns associative array from given array, $callable method is used to get item hash as array key.
     * @template T
     * @param iterable<T> $items
     * @param callable $callable Gets item as argument, returns string for hash.
     * @return array<string, T>
     */
    public static function createHashSet(iterable $items, callable $callable): array
    {
        return self::createHashMap($items, $callable);
    }

    /**
     * Returns associative array from given array, $callable method is used to get item hash used as array key.
     * @template T
     * @param iterable<T> $items
     * @param callable(mixed): string $callable Gets item as argument, returns string for hash.
     * @return array<string, T>
     */
    public static function createHashMap(iterable $items, callable $callable): array
    {
        if (empty($items)) {
            return [];
        }
        $indexed = [];
        foreach ($items as $item) {
            $index = $callable($item);
            if (!is_string($index)) {
                throw new InvalidArgumentException(
                    '$callable must return string. Got (' . gettype($index) . ') "' . $index . '"'
                );
            }
            $indexed[$index] = $item;
        }
        return $indexed;
    }

    /**
     * tests if is array empty
     * @template T
     * @param array<T> $array to test
     * @return bool true if empty
     */
    public static function isEmpty(array $array): bool
    {
        return empty($array);
    }

    /**
     * returns number of elements in $array
     * @template T
     * @param array<T> $array
     * @return int
     */
    public static function length(array $array): int
    {
        return count($array);
    }

    /**
     * returns first element of iterable or null if iterable is empty
     * @template T
     * @param iterable<T> $array
     * @return T|null first element or null if iterable is empty
     */
    public static function first(iterable $array)
    {
        foreach ($array as $element) {
            return $element;
        }
        return null;
    }

    /**
     * returns last element of iterable or null if iterable is empty
     * @template T
     * @param iterable<T> $array
     * @return T|null last element or null if iterable is empty
     */
    public static function last(iterable $array)
    {
        $element = null;
        foreach ($array as $element) {
        }
        return $element;
    }

    /**
     * @template T
     * @param iterable<T> $array
     * @param callable $predicate predicate to test
     * @return bool true if $predicate is true for every element of $array
     */
    public static function every(iterable $array, callable $predicate): bool
    {
        foreach ($array as $item) {
            if (!call_user_func($predicate, $item)) {
                return false;
            }
        }

        return true;
    }

    /**
     * @template T
     * @param iterable<T> $array
     * @param callable $predicate predicate to test
     * @return bool true if $predicate is true for some elements of $array
     */
    public static function some(iterable $array, callable $predicate): bool
    {
        foreach ($array as $item) {
            if (call_user_func($predicate, $item)) {
                return true;
            }
        }

        return false;
    }
}
