<?php

namespace IZON\IO;

use IZON\IO\Exceptions\FilesystemAccessException;

/**
 * interface for file, it can be implemented by any storage like fs, dropbox, ...
 */
interface FileInterface
{
    /**
     * @return string file name with extension and without path
     */
    public function getFileName(): string;

    /**
     * @return string extension of file
     */
    public function getFileExtension(): string;

    /**
     * @return int file size in Bytes
     */
    public function getFileSize(): int;

    /**
     * @param int $decimals number of decimal places do show
     * @return string human-readable size (e.g. 42MB)
     */
    public function getHumanReadableFileSize(int $decimals = 2): string;

    /**
     * @return string mime type of file
     */
    public function getMimeType(): string;

    /**
     * @return string file content as a string
     * @throws FilesystemAccessException
     */
    public function getFileContents(): string;

    /**
     * @return resource return stream to file
     * @throw FilesystemAccessException
     */
    public function getFileStream();

    /**
     * @return int timestamp of last file modification
     */
    public function getTimestamp(): int;

    /**
     * uid of origin (e.g. name of filesystem) of the file, null identifies machines fs
     * @return string|null
     */
    public function getOriginUID(): ?string;

    /**
     * @return string unique identifier of file on filesystem
     */
    public function getFileUID(): string;
}
