<?php

namespace IZON\IO;

use Exception;
use Serializable;
use SplFileInfo;
use SplFileObject;
use finfo;
use \IZON\Utils\Date;

/**
 * raster image interface
 */
interface RasterImageInterface extends ImageInterface {

    /**
     * @return int pixel width of image will be displayed in browsers or image viewers
     * applies EXIF image orientation or other transformations that result in different size in browsers or image viewers
     */
    public function getPixelWidth(): int;

    /**
     * @return int pixel height of image will be displayed in browsers or image viewers
     * applies EXIF image orientation or other transformations that result in different size in browsers or image viewers
     */
    public function getPixelHeight(): int;
}
