<?php


namespace IZON\IO;


trait FileHelperTrait {



    public function getFriendlyFileSize(int $decimals = 2): string {
        $units =  ["B", " KB", " MB", " GB", " TB", "PB"];
        $rawSize = $this->getFileSize();

        $position = 0;
        while($rawSize >= 1024 && ( $rawSize / 1024 ) >= 1) {
            $rawSize /= 1024;
            $position++;
        }
        return round($rawSize, $decimals) .' '. $units[$position];
    }

    /**
     * ?????? DOTO: put it here
     * returns "safe" file name ie. removes unsafe characters that can make problems on windows or linux fs
     * also conversts all characters to lowercase
     * @param string $name
     * @return string
     */
    public static function getSafeFileName($name) {
        $fileName = strtolower(pathinfo($name, PATHINFO_FILENAME));
        $fileExtension = pathinfo($name, PATHINFO_EXTENSION);

        $frontFrom = array(' ', '&aacute;', '&Aacute;', '&auml;', '&Auml;', '&eacute;', '&Eacute;', '&euml;', '&Euml;', '&iacute;', '&Iacute;', '&iuml;', '&Iuml;', '&oacute;', '&Oacute;', '&ouml;', '&Ouml;', '&scaron;', '&Scaron;', '&uacute;', '&Uacute;', '&uuml;', '&Uuml;', '&yacute;', '&Yacute;', '&yuml;', '&Yuml;');
        $frontTo = array('-', 'a', 'a', 'a', 'a', 'e', 'e', 'e', 'e', 'i', 'i', 'i', 'i', 'o', 'o', 'o', 'o', 's', 's', 'u', 'u', 'u', 'u', 'y', 'y', 'y', 'y');

        static $convertTable = array(
            'á' => 'a', 'Á' => 'A', 'ä' => 'a', 'Ä' => 'A', 'č' => 'c',
            'Č' => 'C', 'ď' => 'd', 'Ď' => 'D', 'é' => 'e', 'É' => 'E',
            'ě' => 'e', 'Ě' => 'E', 'ë' => 'e', 'Ë' => 'E', 'í' => 'i',
            'Í' => 'I', 'ï' => 'i', 'Ï' => 'I', 'ľ' => 'l', 'Ľ' => 'L',
            'ĺ' => 'l', 'Ĺ' => 'L', 'ň' => 'n', 'Ň' => 'N', 'ń' => 'n',
            'Ń' => 'N', 'ó' => 'o', 'Ó' => 'O', 'ö' => 'o', 'Ö' => 'O',
            'ř' => 'r', 'Ř' => 'R', 'ŕ' => 'r', 'Ŕ' => 'R', 'š' => 's',
            'Š' => 'S', 'ś' => 's', 'Ś' => 'S', 'ß' => 'S',
            'ť' => 't', 'Ť' => 'T',
            'ú' => 'u', 'Ú' => 'U', 'ů' => 'u', 'Ů' => 'U', 'ü' => 'u',
            'Ü' => 'U', 'ý' => 'y', 'Ý' => 'Y', 'ÿ' => 'y', 'Ÿ' => 'Y',
            'ž' => 'z', 'Ž' => 'Z', 'ź' => 'z', 'Ź' => 'Z',
        );
        $string = str_replace($frontFrom, $frontTo, $fileName);
        $string = mb_strtolower(strtr($string, $convertTable), 'UTF-8');
        $string = preg_replace('/[^a-zA-Z0-9]+/u', '-', $string);
        $string = trim($string);

        if(trim($string) == '') {
            // pokud je celej nazev souboru spatne, tak se mu da nejaky defaultni nazev ve tvaru "default_[rand(0, 1000000)].[puvodni_pripona]"
            $string = 'default_' . rand(0, 1000000);
        }
        return strtolower($string . '.' . $fileExtension);
    }
}
