<?php

namespace IZON\IO;

use \Exception;

/**
 *
 */
class RasterImage extends File implements RasterImageInterface {

    protected bool $initialized = false;

    protected int $width;

    protected int $height;

    protected int $imageType;


    public function getPixelWidth(): int {
        $this->initImageInfo();
        return $this->width;
    }

    public function getPixelHeight(): int {
        $this->initImageInfo();
        return $this->height;
    }

    /**
     * @return int typ obrazku IMAGETYPE_xxx z http://php.net/manual/en/image.constants.php
     */
    public function getType() {
        $this->initImageInfo();
        return $this->imageType;
    }


    /**
     * provede inicializaci infomaci o obrazku
     */
    protected function initImageInfo() {
        if(!$this->initialized) {
            $imageSize = getimagesize($this->file->getRealPath());
            if($imageSize === false) {
                throw new Exception("File ". $this->file->getRealPath() ." is not image");
            }

            $this->width = $imageSize[0];
            $this->height = $imageSize[1];
            $this->imageType = $imageSize[2];

            $exif = @exif_read_data($this->file->getRealPath()) ?: [];
            if(!empty($exif['Orientation']) && in_array($exif['Orientation'], [6,8])) {
                $this->width = $imageSize[1];
                $this->height = $imageSize[0];
            }
        }
    }

    /**
     *
     * @param string|File $file file to test if is image
     * @return boolean
     */
    public static function isImage($file) {
        if( $file instanceof File) {
            $file = $file->getRealPath();
        }
        return exif_imagetype($file) !== false;
    }
}
