<?php

namespace IZON\IO;



/**
 * interface for file, it can be implemented by any storage like fs, dropbox, ...
 */
interface FileInterface {

    /**
     * @return string clean file name without path
     */
    public function getFileName();

    /**
     * @return string extension of file
     */
    public function getFileExtension();

    /**
     * @return int file size in Bytes
     */
    public function getFileSize();

    /**
     * @param int $decimals number of decimal places
     * @return string human readable size
     */
    public function getFriendlyFileSize(int $decimals = 2): string;

    /**
     * @return string mime type of file
     */
    public function getMimeType();

    /**
     * @return string file content
     */
    public function getFileContents() : string;

    /**
     * @return resource return stream to file
     */
    public function getFileStream();

    /**
     * @return int
     */
    public function getTimestamp(): int;

    /**
     * origin of the file, nan be identifier of fs
     * @return string|null
     */
    public function getOriginUID(): ?string;

    /**
     * @return string
     */
    public function getFileUID() : string;

}
