<?php


namespace IZON\Utils;


/**
 * utility functions for arrays
 * @package IZON\Utils
 */
class ArrayUtils {

    /**
     * if iterable is not array extracts elements from iterable to array or returns original array otherwise
     * @param iterable $iterable
     * @return array
     *
     * @deprecated use ArrayUtils::toArray instead
     */
    public static function extract(iterable $iterable): array {
        return self::toArray($iterable);
    }

    /**
     * if iterable is not array extracts elements from iterable to array or returns original array otherwise
     * @param iterable $iterable
     * @return array
     */
    public static function toArray(iterable $iterable): array {
        if( is_array($iterable) ) {
            return $iterable;
        }
        return iterator_to_array($iterable);
    }

    /**
     * Returns associative array from given array, $callable method is used to get item hash as array key.
     * @param iterable $items
     * @param callable $callable Gets item as argument, returns string for hash.
     * @return array
     */
    public static function createHashSet(iterable $items, callable $callable): array {
        if(empty($items)) {
            return [];
        }
        $indexed = [];
        foreach($items as $item) {
            $index = $callable($item);
            $indexed[$index] = $item;
        }
        return $indexed;
    }
}
