<?php

namespace IZON\IO;

use \Exception;

/**
 * 
 */
class RasterImage extends File implements RasterImageInterface {
    
    protected $imageSize = NULL;

    protected $imageInfo = NULL;
    
    public function getPixelWidth(): int {
        $this->initImageInfo();
        return $this->imageSize[0];
    }
    
    public function getPixelHeight(): int {
        $this->initImageInfo();
        return $this->imageSize[1];
    }
    
    /**
     * @return int typ obrazku IMAGETYPE_xxx z http://php.net/manual/en/image.constants.php
     */
    public function getType() {
        $this->initImageInfo();
        return $this->imageInfo[2];
    }
    
    

    /**
     * provede inicializaci infomaci o obrazku
     */
    protected function initImageInfo() {
        if($this->imageSize === NULL) {
            $this->imageSize = getimagesize($this->file->getRealPath(), $this->imageInfo);
            $this->imageInfo = getimagesize($this->file->getRealPath(), $this->imageInfo);
        }
        if( $this->imageSize === FALSE) {
            throw new Exception("File ". $this->file->getRealPath() ." is not image");
        }
    }

    /**
     * 
     * @param string|File $file file to test if is image
     * @return boolean
     */
    public static function isImage($file) {
        if( $file instanceof File) {
            $file = $file->getRealPath();
        }
        return exif_imagetype($file) !== FALSE;
    }
}