<?php

/**
 * funkce for work with strings
 */

namespace IZON\String;

/**
 * testuje jestli $haystack zacina $needle
 * @param string $haystack
 * @param string $needle
 * @return boolean
 */
function startsWith($haystack, $needle) {
    if($haystack === null) {
        trigger_error('Argument 1 (haystack) passed to startsWith() must be of the type string, null given', E_USER_DEPRECATED);
        $haystack = '';
    }
    if($needle === null) {
        trigger_error('Argument 2 (needle) passed to startsWith() must be of the type string, null given', E_USER_DEPRECATED);
        $needle = '';
    }
    if (function_exists('str_starts_with')) {
        return str_starts_with($haystack, $needle);
    }
    // search backwards starting from haystack length characters from the end
    return $needle === ""
            || strrpos($haystack, $needle, -mb_strlen($haystack)) !== FALSE;
}

/**
 * testuje jestli $haystack konci $needle
 * @param string $haystack 
 * @param string $needle
 * @return boolean
 */
function endsWith($haystack, $needle) {
    if($haystack === null) {
        trigger_error('Argument 1 (haystack) passed to endsWith() must be of the type string, null given', E_USER_DEPRECATED);
        $haystack = '';
    }
    if($needle === null) {
        trigger_error('Argument 2 (needle) passed to endsWith() must be of the type string, null given', E_USER_DEPRECATED);
        $needle = '';
    }
    if (function_exists('str_ends_with')) {
        return str_ends_with($haystack, $needle);
    }
    // search forward starting from end minus needle length characters
    return $needle === ""
            || (($temp = strlen($haystack) - mb_strlen($needle)) >= 0
                && strpos($haystack, $needle, $temp) !== FALSE);
}
