<?php

namespace IZON\Utils;

use Exception;

use function \IZON\String\startsWith;
use function \IZON\String\endsWith;

/**
 * Description of Slug
 *
 * @author Kotras Jan
 */
class Slug {

    public function __construct() {
        throw new Exception('Slug is static class');
    }

    /**
     * vrati retezec ocesany o diakritiku, mezery (nahrazeny -) a o vsecky skarede znaky
     * Return string without diacritics, spaces and dangerous chars
     * @staticvar array $convertTable
     * @param string $name
     * @return string
     */
    public static function createSlug($name) {
        $frontFrom = array(' ', '&aacute;', '&Aacute;', '&auml;', '&Auml;', '&eacute;', '&Eacute;', '&euml;', '&Euml;', '&iacute;', '&Iacute;', '&iuml;', '&Iuml;', '&oacute;', '&Oacute;', '&ouml;', '&Ouml;', '&scaron;', '&Scaron;', '&uacute;', '&Uacute;', '&uuml;', '&Uuml;', '&yacute;', '&Yacute;', '&yuml;', '&Yuml;');
        $frontTo = array('-', 'a', 'a', 'a', 'a', 'e', 'e', 'e', 'e', 'i', 'i', 'i', 'i', 'o', 'o', 'o', 'o', 's', 's', 'u', 'u', 'u', 'u', 'y', 'y', 'y', 'y');

        static $convertTable = array(
            'á' => 'a', 'Á' => 'A', 'ä' => 'a', 'Ä' => 'A', 'č' => 'c',
            'Č' => 'C', 'ď' => 'd', 'Ď' => 'D', 'é' => 'e', 'É' => 'E',
            'ě' => 'e', 'Ě' => 'E', 'ë' => 'e', 'Ë' => 'E', 'í' => 'i',
            'Í' => 'I', 'ï' => 'i', 'Ï' => 'I', 'ľ' => 'l', 'Ľ' => 'L',
            'ĺ' => 'l', 'Ĺ' => 'L', 'ň' => 'n', 'Ň' => 'N', 'ń' => 'n',
            'Ń' => 'N', 'ó' => 'o', 'Ó' => 'O', 'ö' => 'o', 'Ö' => 'O',
            'ř' => 'r', 'Ř' => 'R', 'ŕ' => 'r', 'Ŕ' => 'R', 'š' => 's',
            'Š' => 'S', 'ś' => 's', 'Ś' => 'S', 'ß' => 'S',
            'ť' => 't', 'Ť' => 'T',
            'ú' => 'u', 'Ú' => 'U', 'ů' => 'u', 'Ů' => 'U', 'ü' => 'u',
            'Ü' => 'U', 'ý' => 'y', 'Ý' => 'Y', 'ÿ' => 'y', 'Ÿ' => 'Y',
            'ž' => 'z', 'Ž' => 'Z', 'ź' => 'z', 'Ź' => 'Z',
        );

        // oriznout jmeno
        $name = trim($name);
        $string = str_replace($frontFrom, $frontTo, $name);
        $string = mb_strtolower(strtr($string, $convertTable), 'UTF-8');

        //change other char which I do not want to.
        $string = preg_replace('/[^a-zA-Z0-9]+/u', '-', $string);

        // odstran po sobe nasledujici pomlcky
        while(strpos($string, '--') !== false) {
            $string = str_replace('--', '-', $string);
        }

        // odstran - ze zacatku
        if(startsWith($string, "-")) {
            $string = substr($string, 1);
        }
        // odstran - z konce
        if(endsWith($string, "-")) {
            $string = substr($string, 0, strlen($string) - 1);
        }
        return strtolower($string);
    }

    /**
     * Zkontroloje jestli je řetezec ve bezpecném tvar (slug)
     * Check if string is safe, string is slug
     * @param string $string
     * @return boolean
     */
    public static function isStringSlug($string) {
        $result = preg_match('/^[a-z0-9-]+$/', $string);
        if(!empty($result)) {
            return true;
        }
        return false;
    }

}
