<?php

namespace IZON\IO;

use \Exception;

/**
 * 
 */
class Image extends File {
    
    protected $imageSize = NULL;

    protected $imageInfo = NULL;
    
    public function getWidth() {
        $this->initImageInfo();
        return $this->imageSize[0];
    }
    
    public function getHeight() {
        $this->initImageInfo();
        return $this->imageSize[1];
    }
    
    /**
     * @return int typ obrazku IMAGETYPE_xxx z http://php.net/manual/en/image.constants.php
     */
    public function getType() {
        $this->initImageInfo();
        return $this->imageInfo[2];
    }
    
    

    /**
     * provede inicializaci infomaci o obrazku
     */
    protected function initImageInfo() {
        if($this->imageSize === NULL) {
            $this->imageSize = getimagesize($this->getFsPath(), $this->imageInfo);
            $this->imageInfo = getimagesize($this->getFsPath(), $this->imageInfo);
        }
        if( $this->imageSize === FALSE) {
            throw new Exception("File ". $this->getFsPath() ." is not image");
        }
    }

    /**
     * 
     * @param string|File $file file to test if is image
     * @return boolean
     */
    public static function isImage($file) {
        if( $file instanceof File) {
            $file = $file->getFsPath();
        }
        return exif_imagetype($file) !== FALSE;
    }
}