<?php

namespace IZON\Object;

/**
 * fuctions for work with objects
 */

use Exception;
use IZON\Utils\ObjectUtils;

/**
 * provadi shalow copy
 * kopiruje property z $orig do $dest pres gettery a settery
 * property se kopiruje pokud existuje get* metoda v $orig a set* metoda v $dest
 * @param object $dest to
 * @param object $orig from
 * @param array $ignoreProperties properties to be ignored while copying
 * @throws Exception
 */
function copyProperties($dest, $orig, array $ignoreProperties = []): void
{
    ObjectUtils::copyProperties($dest, $orig, $ignoreProperties);
}

function createGetterMethodName($propertyName)
{
    $methodName = "get" . ucfirst($propertyName);
    return $methodName;
}

function createIsMethodName($propertyName)
{
    $methodName = "is" . ucfirst($propertyName);
    return $methodName;
}

function createSetterMethodName($propertyName)
{
    $methodName = "set" . ucfirst($propertyName);
    return $methodName;
}
