<?php


namespace IZON\Utils;

/**
 * utility functions for strings
 * @package IZON\Utils
 */
class StringUtils
{
    /**
     * true if $haystack starts with $needle
     */
    public static function startsWith(?string $haystack, ?string $needle): bool
    {
        if ($haystack === null) {
            trigger_error('Argument 1 (haystack) passed to startsWith() must be of the type string, null given', E_USER_DEPRECATED);
            $haystack = '';
        }
        if ($needle === null) {
            trigger_error('Argument 2 (needle) passed to startsWith() must be of the type string, null given', E_USER_DEPRECATED);
            $needle = '';
        }
        if (function_exists('str_starts_with')) {
            return str_starts_with($haystack, $needle);
        }
        // search backwards starting from haystack length characters from the end
        return $needle === ""
            || strrpos($haystack, $needle, -mb_strlen($haystack)) !== false;
    }

    /**
     * true if $haystack starts with $needle
     */
    public static function endsWith(?string $haystack, ?string $needle): bool
    {
        if ($haystack === null) {
            trigger_error('Argument 1 (haystack) passed to endsWith() must be of the type string, null given', E_USER_DEPRECATED);
            $haystack = '';
        }
        if ($needle === null) {
            trigger_error('Argument 2 (needle) passed to endsWith() must be of the type string, null given', E_USER_DEPRECATED);
            $needle = '';
        }
        if (function_exists('str_ends_with')) {
            return str_ends_with($haystack, $needle);
        }
        // search forward starting from end minus needle length characters
        return $needle === ""
            || (($temp = strlen($haystack) - mb_strlen($needle)) >= 0
                && strpos($haystack, $needle, $temp) !== false);
    }
}
