<?php

namespace IZON\Utils;

use Exception;

/**
 * trida reprzentujici dane Locale
 *
 * pouziva stejny tvar jako http://php.net/manual/en/class.locale.php z php rozsireni intl
 *
 * seznam vsech kodu lang
 * http://www.iana.org/assignments/language-subtag-registry/language-subtag-registry
 * https://docs.oracle.com/cd/E13214_01/wli/docs92/xref/xqisocodes.html
 */
class Locale
{
    /**
     * @var string jazyk lokale
     */
    protected $language;
    
    /**
     * @var string|null jake pislo se ma pouzit
     */
    protected $script = null;

    /**
     * @var string|null jaka se ma pouzit zeme
     */
    protected $country = null;
            
    /**
     * @var string|null jaka varianta 1 locale se ma pouzit
     */
    protected $variant1 = null;

    /**
     * @var string|null jaka varianta 2 locale se ma pouzit
     */
    protected $variant2 = null;
    
    protected $private1 = null;
    
    protected $private2 = null;
    
    
    public function __construct($language, $country = null)
    {
        $this->language = $language;
        $this->country = $country;
    }
    
    public function getLanguage()
    {
        return $this->language;
    }

    public function getCountry()
    {
        return $this->country;
    }

    public function getVariant()
    {
        return $this->variant1;
    }
    
    public function toLocaleTag()
    {
        return $this->language . "-" . $this->country;
    }

    /**
     * prevede retezec definujici locale http://php.net/manual/en/class.locale.php na tridu Locale
     * @param string $localeTag
     * @return Locale
     * @throws Exception
     */
    public static function forLocaleTag($localeTag)
    {
        if (extension_loaded('intl')) { // kontrola jestli ma intl
            $localeArray = \Locale::parseLocale($localeTag);
            
            $locale = new Locale($localeArray['language']);
            if (isset($localeArray['region'])) {
                $locale->country = $localeArray['region'];
            }
            
            // TODO: implement opher intl parameters
            return $locale;
        } else {
            $localeTag = str_replace("_", "-", $localeTag);
            $localeArray = explode("-", $localeTag);
            if (count($localeArray) > 2) {
                throw new Exception("Nepodporovane locale $localeTag. Podporovane jsou jen locale slozen ze zeme a jazyka. pr: cz_CZ, en-US. Pro lepsi podporu locale nainstalujte php rozsireni intl");
            } elseif (count($localeArray) == 0) {
                throw new Exception("Pro vytvoreni locale je potreba zadat alespon jazyk");
            }
            $locale = new Locale($localeArray[0]);
            if (count($localeArray) == 2) {
                $locale->country = $localeArray[1];
            }
            return $locale;
        }
    }
}
