<?php

namespace IZON\Utils;

/**
 * Obdba java.util.Collection implementujivci IteratorAggregate z php coz je equivalent Iterable
 *
 * dalsi minspirace
 * http://www.doctrine-project.org/api/common/2.1/class-Doctrine.Common.Collections.Collection.html#_map
 */
interface Collection extends \IteratorAggregate
{
    /**
     *
     * @param mixed $element
     * @return boolean
     *
     */
    public function add($element);
    
    /**
     * prida vsechny
     * @param Collection|array $c
     * @return boolean
     */
    public function addAll($c);
    
    /**
     * odstrani vsechny prvky
     */
    public function clear();
     
    /**
     *
     * @param mixed $o obsahuje element
     * @param bool $strict If the second parameter strict is set to TRUE then the in_array() function will also check the types of the needle in the haystack.
     * @return boolean
     */
    public function contains($o);
    
    /**
     *
     * @param Collection|array $c
     * @return boolean
     */
    public function containsAll($c);

    /**
     * @return boolean
     */
    public function isEmpty();

    /**
     * odstrani dany element
     * @param mixed $o
     * @return boolean
     */
    public function removeElement($o);
        
    /**
     *
     * @param Collection|array $c
     * @return boolean
     */
    public function removeAll($c);
    
    /**
     *
     * @param Collection|array $c
     * @return boolean
     */
    public function retainAll($c);
    
    /**
     * @return int
     */
    public function size();

    /**
     * @return array Description
     */
    public function toArray();
}
