<?php

namespace IZON\Utils;

/**
 * Description of Password
 *
 * @author Vítězslav Jahn <jahn@izon.cz>
 */
class Password
{
    /**
     * returns hash of password using $cipherName sipher
     * currently only blowfish cipher supported
     * @param string $password
     * @param string $cipherName
     * @return string
     */
    public static function getPasswordHash($password, $cipherName = "blowfish")
    {
        // use blowfish hash function with cost 10 ai. 10^10 iterations
        $options = [
            'cost' => 10,
        ];
        $hash = password_hash($password, PASSWORD_BCRYPT, $options);
        return $hash;
    }

    /**
     * @deprecated use getPasswordHash instead
     * Vrati zaheshovane heslo
     * @param string $password
     * @return string
     */
    public static function getHashedPassord($password)
    {
        return self::getPasswordHash($password);
    }

    /**
     * Vygeneruje nove heslo
     *
     * @param integer $lenght
     * @return string zahashovane heslo
     */
    public static function generatePassword($lenght = 8)
    {
        return self::getPasswordHash(self::generatePasswordInternal($lenght));
    }

    /**
     * Generate string of specific length
     * @param integer $length
     * @return string
     */
    public static function generatePasswordInternal($length = 8)
    {
        $validate = true;
        srand((float) microtime() * 1000000);  // inicializuje generátor náhodných čísel
        $possible_charactors = "abcdefghijklmnopqrstuvwxyz123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ"; /* definujeme
          možné znaky pro heslo */
        $string = "";
        while (strlen($string) < $length) { // opakuj cyklus dokud počet znaků string je menší než length
            $string .= substr($possible_charactors, rand() % (strlen($possible_charactors)), 1);
            // vybereme náhodný znak z množiny znaků pro heslo
        }
        return $string;
    }
}
