<?php

namespace IZON\Utils;

use Exception;

use IZON\Lang\NotImplementedException;

/**
 * Mnozina ktera je reprezentovana serazenym polem
 *
 * @author drymld
 */
class OrderedSet implements SetCollection
{
    /**
    * kolekce ulozenych prvku
    */
    protected $elements = [];

    /**
     * jaka trida maji byt prvky
     * @var string|null class of inserted elements
     */
    protected $class = null;


    /**
     *
     * @param Collection|array $elements elementy seznamu nebo trida, ktara se ma v seznamu ukladat
     * @param string $class trida, ktara se ma v seznamu ukladat
     */
    public function __construct($elements = [], $class = null)
    {
        if ($class !== null) {
            if (!class_exists($class)) {
                new $class(); // moznaradeji vyhazovat vyjimku ze trida neexistuje
            }
        }
        if ($elements !== null) {
            if (class_exists($elements)) {
                $class = $elements;
                $elements = [];
            } else {
                if ($elements instanceof Collection) {
                    $elements = $elements->toArray();
                }
                if (!is_array($elements)) {
                    throw new Exception("$elements musi by array nebo instance Collection");
                }
            }
        }

        $this->elements = $elements;
        $this->class = $class;
    }

    public function add($e)
    {
        if ($this->contains($e)) {
            return false;
        } else {
            $elements[] = $e;
            return true;
        }
    }

    public function addAll($c)
    {
        throw new NotImplementedException();
    }

    public function clear()
    {
        $this->elements = [];
    }

    public function contains($o)
    {
        return in_array($o, $this->elements, $this->class);
    }

    public function containsAll($c)
    {
        throw new NotImplementedException();
    }

    /**
     * Vrati iterator pro iteraci pres prvky
     * @return \Traversable<mixed, mixed>
     */
    public function getIterator()
    {
        return new \ArrayIterator($this->elements);
    }

    public function isEmpty()
    {
        return empty($this->elements);
    }

    public function removeAll($c)
    {
        throw new NotImplementedException();
    }

    public function removeElement($o)
    {
        $index = array_search($o, $this->elements, $this->class);
        if ($index === false) {
            return false;
        }
        // posune prvky
        for ($i = $index; $i < count($this->elements) - 1; $i++) {
            $this->elements[$i] = $this->elements[$i + 1];
        }

        // zrusi posledni prvek
        unset($this->elements[count($this->elements) - 1]);

        return true;
    }

    public function retainAll($c)
    {
        throw new NotImplementedException();
    }

    public function size()
    {
        return count($this->elements);
    }

    public function toArray()
    {
        return $this->elements;
    }
}
