<?php


namespace IZON\Utils;

/**
 * utility functions for arrays
 * @package IZON\Utils
 */
class ArrayUtils
{
    /**
     * if iterable is not array extracts elements from iterable to array or returns original array otherwise
     * @param iterable $iterable
     * @return array
     */
    public static function toArray(iterable $iterable): array
    {
        if (is_array($iterable)) {
            return $iterable;
        }
        return iterator_to_array($iterable);
    }

    /**
     * Returns associative array from given array, $callable method is used to get item hash as array key.
     * @param iterable $items
     * @param callable $callable Gets item as argument, returns string for hash.
     * @return array
     */
    public static function createHashSet(iterable $items, callable $callable): array
    {
        if (empty($items)) {
            return [];
        }
        $indexed = [];
        foreach ($items as $item) {
            $index = $callable($item);
            $indexed[$index] = $item;
        }
        return $indexed;
    }

    /**
     * tests if is array empty
     * @param array $array to test
     * @return bool true if empty
     */
    public static function isEmpty(array $array): bool
    {
        return empty($array);
    }

    /**
     * vraiti pocet prvku pole
     * @param array $array
     * @return integer
     */
    public static function length(array $array)
    {
        return count($array);
    }

    /**
     * returns first element of iterable or null if iterable is empty
     * @param iterable $array
     * @return mixed|null
     */
    public static function first(iterable $array)
    {
        foreach ($array as $element) {
            return $element;
        }
        return null;
    }

    /**
     * returns last element of iterable or null if iterable is empty
     * @param iterable $array
     * @return mixed|null
     */
    public static function last(iterable $array)
    {
        $element = null;
        foreach ($array as $element) {
        }
        return $element;
    }
}
