<?php

namespace IZON\Object;

/**
 * fuctions for work with objects
 */

use Exception;

/**
 * provadi shalow copy
 * kopiruje property z $orig do $dest pres gettery a settery
 * property se kopiruje pokud existuje get* metoda v $orig a set* metoda v $dest
 * @param object $dest to
 * @param object $orig from
 * @param array $ignoreProperties properties to be ignored while copying
 * @throws Exception
 */
function copyProperties($dest, $orig, array $ignoreProperties = [])
{
    if (!is_object($orig)) {
        throw new Exception('$orig neni objekt');
    }
    if (!is_object($dest)) {
        throw new Exception('$dest neni objekt');
    }
    
    $methodNames = get_class_methods($orig);
    foreach ($methodNames as $methodName) {
        if (\IZON\String\startsWith($methodName, "get")) { // existuje get metoda
            $propertyName = str_replace("get", "", $methodName);
            $propertyName = mb_strtolower(mb_substr($propertyName, 0, 1)) . mb_substr($propertyName, 1);
            
            $setMethodName = str_replace("get", "set", $methodName);
            
            if (!in_array($propertyName, $ignoreProperties)
                && method_exists($dest, $setMethodName)) { // existuje set metoda
                $val = $orig->$methodName();
                $dest->$setMethodName($val);
            }
        }
    }
}

function createGetterMethodName($propertyName)
{
    $methodName = "get" . ucfirst($propertyName);
    return $methodName;
}

function createSetterMethodName($propertyName)
{
    $methodName = "set" . ucfirst($propertyName);
    return $methodName;
}

function createIsMethodName($propertyName)
{
    $methodName = "is" . ucfirst($propertyName);
    return $methodName;
}
