<?php

/**
 * pro praci se soubory
 */

namespace IZON\File;

use Exception;

use IZON\IO\File;

/**
 *
 * @param File|string $source from where copy file
 * @param string $destination where to copy file
 * @param array $options options for file coping
 */
function copy($source, $destination, $options = [])
{
    $sourceDir = $source;
    if ($source instanceof File) {
        $sourceDir = $source->getFsPath();
    }
    \copy($sourceDir, $destination);
}

/**
 * presune sobor do jineho adresare
 * @param File|string $source from where copy file
 * @param string $destination where to copy file
 * @param array $options options for file coping
 */
function move($source, $destination, $options = [])
{
    $sourceDir = $source;
    if ($source instanceof File) {
        $sourceDir = $source->getFsPath();
    }
    \rename($sourceDir, $destination);
}

/**
 * Ulozi data do souboru
 * @param string $file - uplna cesta k souboru
 * @param string $data - obsah souboru
 * @param string $mode - mod, v jakem bude soubor vytvoren, defaultne w+
 * @param integer $privs - z jakymi pravy se ma soubor ulozit
 */
function saveToFile($file, $data, $mode = 'w+', $privs = 0777)
{
    $fp = fopen($file, $mode);
    flock($fp, LOCK_EX); // zamkni na zapis, aby se pri soucasnem zapisu neprepisovalo
    fwrite($fp, print_r($data, true));
    flock($fp, LOCK_UN); // odemkni na zapis
    fclose($fp);
    chmod($file, $privs);
}

/**
 * uploaduje soubor na ftp
 *
 * @param array $settings - adresa, login a heslo k ftp
 * @param string $path - cesta na ftp, kam se po prihlaseni prepne
 * @param string $destFile - nazev cilovevho souboru
 * @param string $sourceFile - cesta k zdrojovemu souboru
 * @param string $logfile - kam se ulozi log
 */
function uploadFileToFtp($settings, $path, $destFile, $sourceFile, $logfile = 'logs/ftplog.txt')
{
    $spojeni = ftp_connect($settings['server']);
    ftp_login($spojeni, $settings['login'], $settings['passwd']);
    // ftp_pasv($spojeni, true);
    ftp_chdir($spojeni, $path);
    $ret = false;
    if (file_exists($sourceFile)) {
        if (ftp_put($spojeni, $destFile, $sourceFile, FTP_BINARY)) {
            $ret = true;
            $log = 'File ' . $sourceFile . ' uploaded.';
        } else {
            $log = 'File ' . $sourceFile . ' upload failed.';
        }
    } else {
        $log = 'Upload failed : file ' . $sourceFile . ' doesnt exist.';
    }
    saveToFile($logfile, date('d.m.Y H:i') . '; ' . $log . "\r\n", 'a+');
    ftp_close($spojeni);
    return $ret;
}

/**
 * normalizuje nazev souboru tim ze zmeni \ na / a pokud obsahuje pismeno jednotky tak ho prevede na male pismeno
 * @param string $fileName
 * @return string normalizovany nazev souboru
 */
function normalizeFileName($fileName)
{
    if (\IZON\String\startsWith(strtolower(PHP_OS), "win")) {
        $fileName = str_replace("\\", "/", $fileName);
        $fileName = mb_strtolower($fileName);
    }
    return $fileName;
}

/**
 * vraci true pokud ze se soubor $fimeName nachazi v adresari $dirName
 * @param string $fimeName
 * @param string $dirPath
 */
function isInSubDir($fimeName, $dirPath)
{
    $fimeName = normalizeFileName($fimeName);
    $dirPath = normalizeFileName($dirPath);
    return \IZON\String\startsWith($fimeName, $dirPath);
}

/**
 * normalizuje nazev souboru tim ze zmeni \ na / a pokud obsahuje pismeno jednotky tak ho prevede na male pismeno
 * @param string $path
 * @return string normalizovany nazev souboru
 */
function normalizePath($path)
{
    if (\IZON\String\startsWith(strtolower(PHP_OS), "win")) {
        $path = str_replace("\\", "/", $path);
        $path = mb_strtolower($path);
    }
    return $path;
}

/**
 * vraci true pokud se cesta $path nachazi v adresari $dirPath
 * @param string $path
 * @param string $dirPath
 */
function isPathInSubDir($path, $dirPath)
{
    $path = normalizeFileName($path);
    $dirPath = normalizeFileName($dirPath);
    return \IZON\String\startsWith($path, $dirPath);
}


/**
 * smaze obsah adresare kompletne rekurzivne
 * @param string $dir
 */
function deleteRecursivelly($dir)
{
    if (!file_exists($dir)) {
        throw new Exception("Adresář " . $dir . " neexistuje ne");
    }
    foreach (scandir($dir) as $subFile) {
        $absFileDir = $dir . "/" . $subFile;

        if (is_dir($absFileDir)) {
            if ($subFile != "."
                && $subFile != "..") {
                deleteRecursivelly($absFileDir);
                //               rmdir($absFileDir);
            }
        } else { // je soubor smazat ho
            unlink($absFileDir);
        }
    }
   
    if (is_dir($dir)) { // je adresar, smazt ho
        rmdir($dir);
    } else { // je soubor smazat ho
        unlink($dir);
    }
}
