<?php

namespace IZON\Utils;

use Exception;

/**
 * Static class for Email string 
 *
 * @author Kotras
 */
class Email {

    function __construct() {
        throw new Exception('Email class is static class');
    }

    /**
     * Check if string is email 
     * @param string $string
     * @return boolean
     */
    public static function isEmail($string) {
        if(empty($string)) {
            return false;
        }
        if(!is_string($string)) {
            return false;
        }
        $result = preg_match("/^\w+((-\w+)|(\.\w+))*\@[A-Za-z0-9]+((\.|-)[A-Za-z0-9]+)*\.[A-Za-z0-9]+$/", $string);
        if(empty($result) || $result < 1) {
            return false;
        }
        return true;
    }

    /**
     * Return a domain of email acount
     * @param string $email
     * @return string|false  Return string is sucess or false in fail
     */
    public static function getDomainFromEmail($email) {
        if(!self::isEmail($email)) {
            return false;
        }
        $domain = substr(strrchr($email, "@"), 1);
        return $domain;
    }

    /**
     * Check if email exist - now only by MX record
     * Method need internet connection to funciton
     * @param string $email
     * @return boolean
     */
    public static function isEmailExists($email) {
        $domain = self::getDomainFromEmail($email);
        if(!$domain) {
            return false;
        }
        return checkdnsrr($domain, "MX");
    }

}
