<?php

/**
 * funkce for work with strings
 */

namespace IZON\String;

/**
 * testuje jestli $haystack zacina $needle
 * @param string $haystack
 * @param string $needle
 * @return boolean
 */
function startsWith($haystack, $needle) {
    // search backwards starting from haystack length characters from the end
    return $needle === "" 
            || strrpos($haystack, $needle, -mb_strlen($haystack)) !== FALSE;
}

/**
 * testuje jestli $haystack konci $needle
 * @param string $haystack
 * @param string $needle
 * @return boolean
 */
function endsWith($haystack, $needle) {
    // search forward starting from end minus needle length characters
    return $needle === "" 
            || (($temp = strlen($haystack) - mb_strlen($needle)) >= 0 
                && strpos($haystack, $needle, $temp) !== FALSE);
}
