<?php

namespace IZON\Utils;

/**
 * Description of Password
 *
 * @author Vítězslav Jahn <jahn@izon.cz>
 */
class Password {

  /**
   * Vrati zaheshovane heslo
   * @param string $passwd
   * @return string
   */
  public static function getHashedPassord($password) {
    // use blowfish hash function with cost 10 ai. 10^10 iterations 
    $options = [
        'cost' => 10,
    ];
    $hash = password_hash($password, PASSWORD_BCRYPT, $options);
    return $hash;
  }

  /**
   * Vygeneruje nove heslo
   * 
   * @param integer $lenght
   * @return string zahashovane heslo
   */
  public static function generatePassword($lenght = 8) {
    return self::getHashedPassord(self::generatePasswordInternal($lenght));
  }
  
  /**
   * Generate string of specific length
   * @param type $length
   * @return type
   */
  public static function generatePasswordInternal($length = 8){
    $validate = true;
    srand((double)microtime()*1000000);  // inicializuje generátor náhodných čísel
    $possible_charactors = "abcdefghijklmnopqrstuvwxyz123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ"; /* definujeme
    možné znaky pro heslo */
    $string="";
    while(strlen($string)<$length) { // opakuj cyklus dokud počet znaků string je menší než length
      $string .= substr($possible_charactors, rand()%(strlen($possible_charactors)),1);
    // vybereme náhodný znak z množiny znaků pro heslo
    }
    return $string;
  }
}
