<?php

namespace IZON\Utils;

/**
 * trida reprzentujici dane Locale
 * 
 * pouziva stejny tvar jako http://php.net/manual/en/class.locale.php z php rozsireni intl
 * 
 * seznam vsech kodu lang 
 * http://www.iana.org/assignments/language-subtag-registry/language-subtag-registry
 */
class Locale {
    
    /**
     * @var string jazyk lokale
     */
    protected $language;
    
    /**
     * @var string jake pislo se ma pouzit
     */
    protected $script = NULL;

    /**
     * @var string jaka se ma pouzit zeme
     */
    protected $country = NULL; 
            
    /**
     * @var string jaka varianta 1 locale se ma pouzit
     */
    protected $variant1 = NULL;

    /**
     * @var string jaka varianta 2 locale se ma pouzit
     */
    protected $variant2 = NULL;
    
    protected $private1 = NULL;
    
    protected $private2 = NULL;
    
    public function __construct($language, $country = NULL) {
        $this->language = $language;
        $this->country = $country;
    }
    
    function getLanguage() {
        return $this->language;
    }

    function getCountry() {
        return $this->country;
    }

    function getVariant() {
        return $this->variant;
    }
    
    function toLocaleTag() {
        return $this->language ."-". $this->country;
    }

    /**
     * prevede retezec definujici locale http://php.net/manual/en/class.locale.php na tridu Locale
     * @param string $localeTag
     * @return Locale
     * @throws Exception
     */
    static function forLocaleTag($localeTag) {
        if( extension_loaded('intl') ) { // kontrola jestli ma intl
            $localeArray = \Locale::parseLocale($localeTag);
            $locale = new Locale($localeArray['language']);
            if( isset($localeArray['region']) ) {
                $locale->country = $localeArray['region'];
            }
            // TODO: doimplentovat dalsi informace z intl
            return $locale;
        } else {
            $localeTag = str_replace("_", "-", $localeTag);
            $localeArray = explode("-", $localeTag);
            if( count($localeArray) > 2 ) {
                throw new Exception("Nepodporovane locale $localeTag. Podporovane jsou jen locale slozen ze zeme a jazyka. pr: cz_CZ, en-US. Pro lepsi podporu locale nainstalujte php rozsireni intl");
            } else if( count($localeArray) == 0 ) {
                throw new Exception("Pro vytvoreni locale je potreba zadat alespon jazyk");
            }
            $locale = new Locale($localeArray[0]);
            if( count($localeArray) == 2 ) {
                $locale->country = $localeArray[1];
            }
            return $locale;
        }
    }
}
