<?php

namespace IZON\Utils;

use \Exception;
use \DateTime;

/**
 * trida reprezentujici datum a cas
 * umoznuje vytvoreni z timestamp a z hodin, minut., sekund, dnu, tydnu, mesicu, let
 */
class Date {

    /**
     * @var DateTime
     */
    private $dateTime;

    /**
     * pokud neni zadana timestamp vytvori se datum s aktualnim casem
     * @param integer timestamp timestamp reprezetujici vytvarene datum
     */
    public function __construct($timestamp = NULL, $timezone = NULL) {
        if ($timestamp === NULL) {
            if ($timezone === NULL) {
                $this->dateTime = new DateTime("now");
            } else {
                $this->dateTime = new DateTime("now", $timezone);
            }
        } else if ($timestamp instanceof DateTime) {
            $this->dateTime = $timestamp;
        } else if (is_long($timestamp)) { // nastavuje timestamp
            $this->dateTime = new DateTime();
            $this->dateTime->setTimestamp($timestamp);
        } else {
            if ($timezone === NULL) {
                $this->timestsamp = DateTime::createFromFormat($format, $time);
            } else {
                $this->timestsamp = DateTime::createFromFormat($format, $time, $timezone);
            }
        }
    }

    /**
     * ekvivalentni http://php.net/manual/en/datetime.createfromformat.php
     */
    static function createFromFormat($format, $time, DateTimeZone $timezone = NULL) {
        if ($timezone === NULL) {
            $datetime = DateTime::createFromFormat($format, $time);
        } else {
            $datetime = DateTime::createFromFormat($format, $time, $timezone);
        }
        if ($datetime == FALSE) {
            return FALSE;
        } else {
            return new Date($datetime);
        }
    }

    /**
     * @param string format format ve stylu php funkce date http://cz.php.net/manual/en/function.date.php a czdate
     * @param string lang jazyk, ktery se ma pouzit
     * @return string formatovane datum podle zadaneho parametru
     */
    function format($format) {
        return $this->dateTime->format($format);
    }

    //    /**
    //     * @return integer vraci rok tohoto data
    //     */
    //    function getYear() {
    //        return date("Y", $this->timestsamp);
    //    }
    //
    //    /**
    //     * @return integer vraci mesic tohoto data
    //     */
    //    function getMonth() {
    //        return date("n", $this->timestsamp);
    //    }
    //
    //    /**
    //     * @return integer vraci den tohoto data
    //     */
    //    function getDay() {
    //        return date("d", $this->timestsamp);
    //    }
    //
    //    /**
    //     * @return integer vraci den tohoto data (bez 0 na zacatku 05 -> 5)
    //     */
    //    function getJDay() {
    //        return date("j", $this->timestsamp);
    //    }
    //
    //    /**
    //     * @return integer vraci hodinu tohoto data
    //     */
    //    function getHour() {
    //        return date("H", $this->timestsamp);
    //    }
    //
    //    /**
    //     * @return integer vraci minutu tohoto data
    //     */
    //    function getMinute() {
    //        return date("i", $this->timestsamp);
    //    }
    //
    //    /**
    //     * @return integer vraci sekundu tohoto data
    //     */
    //    function getSecond() {
    //        return date("s", $this->timestsamp);
    //    }

    /**
     * @return integer vraci timestamp odpovidajici tomuto datu
     */
    function getTimestamp() {
        return $this->dateTime->getTimestamp();
    }

    /**
     * vraci true, pokud je to datum pred zadanym datem
     * v pripade za zadana hodnota neni datum vyvolava exception
     * @param Date date datum u ktereho se ma zjistit jestli je mensi
     */
    function before($date) {
        if (!is_a($date, self::class))
            throw new Exception("$date musi byt instance date.");
        return $this->getTimestamp() < $date->getTimestamp();
    }

    /**
     * vraci true, pokud je to datum vetsi nez zadane
     * v pripade za zadana hodnota neni datum vyvolava exception
     * @param Date date datum u ktereho se ma zjistit jestli je vetsi
     */
    function after($date) {
        if (!is_a($date, self::class))
            throw new Exception("$date musi byt instance date.");
        return $this->getTimestamp() > $date->getTimestamp();
    }

    /**
     * vraci true, pokud jsou data stejna
     * v pripade za zadana hodnota neni datum vyvolava exception
     * @param Date date datum, ktere se ma porovnat
     */
    function equals($date) {
        if (!is_a($date, self::class))
            throw new Exception("$date musi byt instance date.");
        return $this->getTimestamp() == $date->getTimestamp();
    }

    /**
     * 0 - equalDates,
     * $thisDate > $dataParams = more than 0,
     * $thisDate < $dataParams = less than 0,
     * the value 0 if the argument Date is equal to this Date; a value less than 0 if this Date is before the Date argument; and a value greater than 0 if this Date is after the Date argument.
     */
    function compareTo($date) {
        if (!is_a($date, self::class))
            throw new Exception("$date musi byt instance date.");
        return $this->getTimestamp() - $date->getTimestamp();
    }

    /**
     * @return DateTime
     */
    public function getDateTime() {
        return $this->dateTime;
    }

    /**
     * Add interval to this object
     * @param int $seconds num to add
     * @param int $minutes num to add
     * @param int $hours num to add
     * @param int $days num to add
     * @param int $months num to add
     * @param int $years num to add
     */
    public function addTime($seconds = 0, $minutes = 0, $hours = 0, $days = 0, $months = 0, $years = 0) {
        $interval = self::makeInterval($seconds, $minutes, $hours, $days, $months, $years);
        $this->dateTime->add($interval);
    }

    /**
     * Sub interval from this object
     * @param int $seconds num to sub
     * @param int $minutes num to sub
     * @param int $hours num to sub
     * @param int $days num to sub
     * @param int $months num to sub
     * @param int $years num to sub
     */
    public function subTime($seconds = 0, $minutes = 0, $hours = 0, $days = 0, $months = 0, $years = 0) {
        $interval = self::makeInterval($seconds, $minutes, $hours, $days, $months, $years);
        $this->dateTime->sub($interval);
    }

    /**
     * Make Date interval from number of time arguments
     * @param int $seconds count of seconds in interval
     * @param int $minutes count of minutes in interval
     * @param int $hours count of hours in interval
     * @param int $days count of days in interval
     * @param int $months count of months in interval
     * @param int $years count of years in interval
     * @return \DateInterval
     */
    public static function makeInterval($seconds = 0, $minutes = 0, $hours = 0, $days = 0, $months = 0, $years = 0) {
        foreach(func_get_args() as $key => $arg){
            if(!is_numeric($arg)){
                //number of argument start on 0
                throw new Exception('Interval of argument number: '.$key.' is not integer');
            }
            if($arg < 0){
                //number of argument start on 0
                throw new Exception('Interval of argument number: '.$key.' can not be negative');
            }
        }
        $intervalString = "";

        $intervalString .= "P";
        $intervalString .= $years . "Y";
        $intervalString .= $months . "M";
        $intervalString .= $days . "D";

        $intervalString .= "T";
        $intervalString .= $hours . "H";
        $intervalString .= $minutes . "M";
        $intervalString .= $seconds . "S";

        $interval = new \DateInterval($intervalString);
        return $interval;

    }

}
