<?php
// soucasny modul
$thisModule = PHPView\getParameter(IZON\Admin\MVC\ModuleInfo::MODULE_INFO_INDENTIFIER);
$createURL = AdminPHPView\getModuleActionURL($thisModule->getControllerId(), "edit", [], $thisModule->getIdentifier());

//Module title
AdminPHPView\renderModuleTitle('Užvatelé');

/** @var \IZON\DB\Paginator\PageContent<\IZON\Users\Domain\User> $pageContent */
$pageContent = PHPView\getParameter('pageContent');
?>

<section class="col-xs-12">
    <div class="table-icons" style="display: none;">
        <i class="fas fa-edit" data-fa-symbol="icon--edit"></i>
        <i class="fas fa-trash-alt" data-fa-symbol="icon--delete"></i>
        <i class="fas fa-times" data-fa-symbol="icon--false"></i>
        <i class="fas fa-check" data-fa-symbol="icon--true"></i>
    </div>
    <table id="dynamic-table" class="table--dynamic">
        <thead>
            <tr>
                <th class="sortable sorted--up" style="width: 12rem;" data-property-name="id"><?= __('#') ?></th>
                <th class="sortable sorted--up" data-property-name="email" style="text-align: left"><?= __('Email') ?></th>
                <th class="sortable sorted--up" data-property-name="name" style="text-align: left"><?= __('Jméno') ?></th>
                <th style="width: 13rem;"><?= __('Funkce') ?></th>
            </tr>
        </thead>
        <tbody>
            <?php
            foreach ($pageContent->getPage() as $user) {
                ?>
                <tr>
                    <td><?= $user->getId() ?></td>
                    <td><?= $user->getEmail() ?></td>
                    <td><?= $user->getName() ?></td>
                    <td class="actions">
                    </td>
                <?php
            }
            ?>
        </tbody>
    </table>
</section>

<!-- POPUP - Confirmation of deleting item -->
<div class="popup">
    <div class="popup__message confirmation-deleting">
        <div class="close"><i class="fas fa-times"></i></div>
        <span><?= __('Opravdu chcete smazat záznam') ?> <strong class="zaznam"></strong>?</span>
        <a href="#" class="btn btn--gray" id="back" style="margin-right: 3rem;"><i class="fas fa-angle-left"></i><?= __('Vrátit') ?></a>
        <a href="#" class="btn btn--mint" id="do"><i class="fas fa-trash"></i><?= __('Smazat') ?></a>
    </div>
</div>
