<?php

namespace IZON\Users\Web\Controllers;

use Exception;
use IZON\MVC\Controller;
use IZON\MVC\HttpRequest;
use IZON\MVC\ModelAndView;
use IZON\Users\Services\LoggedWebUserSessionServiceInterface;
use IZON\Users\Web\Forms\UserWebFormFactory;

/**
 *
 */
class ResetPasswordController implements Controller
{
    protected LoggedWebUserSessionServiceInterface $sessionService;

    /**
     * jake view se ma pouzit pro zobrazeni formulare
     * @var string
     */
    protected string $formViewName = "reset-password";

    protected string $resetOKRedirectControllerIdentifier;


    public function __construct(
        LoggedWebUserSessionServiceInterface $sessionService,
        string $formViewName,
        string $resetOKRedirectControllerIdentifier
    ) {
        $this->sessionService = $sessionService;
        $this->formViewName = $formViewName;
        $this->resetOKRedirectControllerIdentifier = $resetOKRedirectControllerIdentifier;
    }

    public function execute(HttpRequest $request)
    {
        $sent = $request->hasParameter('sent');

        $passwordForm = UserWebFormFactory::createResetPasswordForm($this->sessionService->getMinPasswordLength());
        $passwordForm->setValues($request->getParameters());

        $modelAndView = new ModelAndView($this->formViewName);

        $resetPasswdUser = $this->sessionService->getResetPasswordUser(
            $passwordForm->getField("login")->parse(),
            $passwordForm->getField("hash")->parse()
        );

        if ($resetPasswdUser == null) {
            $modelAndView->putParameter("result", "error");
            $modelAndView->putParameter("error", _("Není platný požadavek na reset hesla."));
            return $modelAndView;
        }

        // nastavuje uzivatele pro rest hesla
        $modelAndView->putParameter("form", $passwordForm);

        // nastavuje uzivatele pro rest hesla
        $modelAndView->putParameter("user", $resetPasswdUser);

        if (!$sent) {
            return $modelAndView;
        } else {
            $passwordForm->validate();
            if ($passwordForm->hasErrors()) {
                return $modelAndView;
            }

            try {
                $this->sessionService->resetUserPassword(
                    $resetPasswdUser->getId(),
                    $passwordForm->getField("hash")->parse(),
                    $passwordForm->getField("password")->parse()
                );

                $modelAndView = ModelAndView::createControllerRedirect($this->resetOKRedirectControllerIdentifier);
                return $modelAndView;
            } catch (Exception $e) {
                $modelAndView->putParameter("result", "error");
                $modelAndView->putParameter("error", _("Nepodařílo se změnit heslo. Zkuste to prosím později"));
                return $modelAndView;
            }
        }
    }
}
