<?php

namespace IZON\Users\Web\Controllers;

use IZON\MVC\Controller;
use IZON\MVC\HttpRequest;
use IZON\MVC\Json\JsonResponse;
use IZON\MVC\ModelAndView;
use IZON\Users\Services\LoggedWebUserSessionServiceInterface;

/**
 *
 */
class LogoutController implements Controller
{
    protected LoggedWebUserSessionServiceInterface $sessionService;

    /**
     * defaultni controller na ktery sa ma po loginu presmerovat
     * @var string
     */
    protected $redirectControllerIdentifier = null;


    public function __construct(LoggedWebUserSessionServiceInterface $sessionService)
    {
        $this->sessionService = $sessionService;
    }

    public function execute(HttpRequest $request)
    {
        $this->sessionService->logoutUser();
        $modelAndView = ModelAndView::createControllerRedirect($this->redirectControllerIdentifier);
        return $modelAndView;
    }


    public function ajaxLogout(HttpRequest $request)
    {
        $this->sessionService->logoutUser();

        $modelAndView = new ModelAndView("simple/json-respose");

        $result = JsonResponse::createResponse("logout");
        $modelAndView->putParameter("json", $result);

        return $modelAndView;
    }

    public function setRedirectControllerIdentifier($redirectControllerIdentifier)
    {
        $this->redirectControllerIdentifier = $redirectControllerIdentifier;
    }
}
