<?php

namespace IZON\Users\Presentation\Domain;

use IZON\Users\Domain\User;

/**
 * obsahuje veskere informace o uzivateli
 */
class UserInfo
{
    /**
     * @var User
     */
    protected $user;


    /// gnerovany konstruktor
    public function __construct(User $user)
    {
        $this->user = $user;
    }

    public function getId()
    {
        return $this->user->getId();
    }

    public function getLogin()
    {
        return $this->user->getLogin();
    }

    public function getPassword()
    {
        return $this->user->getPassword();
    }

    public function getEmail()
    {
        return $this->user->getEmail();
    }

    public function getActive()
    {
        return $this->user->getActive();
    }

    public function getName()
    {
        return $this->user->getName();
    }

    public function getRegistrationDate()
    {
        return $this->user->getRegistrationDate();
    }

    public function getLastLoginDate()
    {
        return $this->user->getLastLoginDate();
    }

    /// generovane gettery a settery

    /**
     * @return User
     */
    public function getUser()
    {
        return $this->user;
    }

    public function setUser(User $user)
    {
        $this->user = $user;
    }
}
