<?php

namespace IZON\Users\Domain;

use IZON\DB\DBObject;
use IZON\Utils\Date;

/**
 * požadavek na resetovani hesla
 */
class UserResetPasswordRequest implements DBObject
{
    /**
     * @var integer
     */
    protected $id;

    /**
     * @var string id pro reset hesla
     */
    protected $resetPasswordId;

    /**
     * @var Date do kdy je heslo validni
     */
    protected $resetValidUntil;

    /**
     * @var integer
     */
    protected $fkUserId;


    /// generovane gettery a settery
    public function getId()
    {
        return $this->id;
    }

    public function setId($id)
    {
        $this->id = $id;
    }

    public function getResetPasswordId()
    {
        return $this->resetPasswordId;
    }

    public function setResetPasswordId($resetPasswordId)
    {
        $this->resetPasswordId = $resetPasswordId;
    }

    public function getResetValidUntil()
    {
        return $this->resetValidUntil;
    }

    public function setResetValidUntil(Date $resetValidUntil)
    {
        $this->resetValidUntil = $resetValidUntil;
    }

    public function getFkUserId()
    {
        return $this->fkUserId;
    }

    public function setFkUserId($fkUserId)
    {
        $this->fkUserId = $fkUserId;
    }
}
