<?php

namespace IZON\Users\Config;

use IZON\Users\Admin\Controllers\UserController;
use IZON\Users\Admin\Services\UserService;
use function IZON\Admin\DI\moduleGet;
use function IZON\Admin\DI\moduleIdentifier;
use function IZON\DI\object;

return [
    // povinny parametr pro modul
    'moduleActions' => [
        // jaka akce se ma provest defaultne pri kliknuti na nazev modulu
        'defaultAction' => 'execute',
        // jake akce modul obsahuje a jak se maji pojmenovat
        'actions' => [
            'execute' => [
                'name' => __('Uživatelé - web'),
                'controllerId' => 'admin.userController',
                'action' => 'execute'
            ]
        ],
        // jake akce se maji zobrazit v menu
        'menuActions' => []
    ],

    'admin.userService' => object(UserService::class)
        ->constructor(),

    'admin.userController' => object(UserController::class)
        ->constructor(moduleGet('admin.userService'),
            'izon/users-module/users',
        ),
];
