<?php

namespace IZON\Users\Web\Interceptors;

use IZON\Logs\Logger;
use IZON\MVC\HttpRequest;
use IZON\MVC\Interceptors\Interceptor;
use IZON\MVC\Interceptors\PreHandleResult;
use IZON\MVC\ModelAndView;
use IZON\Users\Services\LoggedWebUserSessionServiceInterface;

/**
 * kontroluje jestli je prihlaseny uzivatel a jestli je tak provede presmerovani na zadanou stranku
 */
class LoggedUserRedirectInterceptor implements Interceptor
{
    protected LoggedWebUserSessionServiceInterface $sessionService;

    /**
     * logger pro tridu
     * @var Logger
     */
    protected $log;

    /**
     * controller, na ktery se ma po prihlaseni presmerovat
     * @var string
     */
    protected $redirectControllerIdentifier = null;


    public function __construct(LoggedWebUserSessionServiceInterface $sessionService, $redirectControllerIdentifier)
    {
        $this->sessionService = $sessionService;
        $this->redirectControllerIdentifier = $redirectControllerIdentifier;

        // logovani
        $this->log = Logger::getLogger(__CLASS__);
    }

    public function afterCompletion(HttpRequest $request, $exception)
    {
    }

    public function postHandle(HttpRequest $request, ModelAndView $model)
    {
        //        return $model;
    }

    public function preHandle(HttpRequest $request)
    {
        if ($this->sessionService->isUserLoggedIn()) {
            $this->log->info("User logged in. Redirect to controller " . $this->redirectControllerIdentifier);
            //            var_dump($request);
            $preHandleResult = PreHandleResult::getInternalRedirect($this->redirectControllerIdentifier);

            return $preHandleResult;
        }
    }

    public function setRedirectControllerIdentifier($redirectControllerIdentifier)
    {
        $this->redirectControllerIdentifier = $redirectControllerIdentifier;
    }
}
