<?php

namespace IZON\Users\Web\Interceptors;

use IZON\MVC\HttpRequest;
use IZON\MVC\Interceptors\Interceptor;
use IZON\MVC\ModelAndView;
use IZON\Users\Services\LoggedWebUserSessionServiceInterface;

/**
 * zpristupni prihlaseneho uzivatele pro view
 */
class LoadLoggedUserInterceptor implements Interceptor
{
    protected LoggedWebUserSessionServiceInterface $loggedWebUserSessionService;

    protected string $loggedUserModelName = "loggedUser";

    public function __construct(LoggedWebUserSessionServiceInterface $sessionService)
    {
        $this->loggedWebUserSessionService = $sessionService;
    }

    public function afterCompletion(HttpRequest $request, $exception)
    {
    }

    public function postHandle(HttpRequest $request, ModelAndView $model)
    {
        if ($this->loggedWebUserSessionService->isUserLoggedIn()) {
            $loggedUser = $this->loggedWebUserSessionService->getLoggedUser();
            $model->putParameter($this->loggedUserModelName, $loggedUser);
        }
        return $model;
    }

    public function preHandle(HttpRequest $request)
    {
    }

    public function setLoggedUserModelName($loggedUserModelName)
    {
        $this->loggedUserModelName = $loggedUserModelName;
    }
}
