<?php

namespace IZON\Users\Domain;

use IZON\DB\DBObject;
use IZON\Utils\Date;
use function IZON\DB\dateTimeField;
use function IZON\DB\transientField;

/**
 * nejaka reference o firme
 */
class User implements DBObject
{
    public const MIN_PASSWD_LENGHT = 5;
    //    public static function __tableName() { return "refs"; }

    /**
     *
     * @var integer
     */
    protected $id;
    //    public static function __id() { return "blah3333"; }

    /**
     *
     * @var string jmeno uzivatel pro zobrazeni
     */
    protected $name;
    //    public static function __name() { return IZON\DB\charField(['maxLength' => 255]); }

    /**
     *
     * @var string login uzivatele
     */
    protected $login;

    /**
     *
     * @var string heslo uzivatele
     */
    protected $password;

    /**
     * @var string email uzivatele
     */
    protected $email;

    /**
     *
     * @var Date datum registrace uzivatele
     */
    protected $registrationDate;

    /**
     * @var Date datum posledniho prihlaseni o aplikace
     */
    protected $lastLoginDate;
    /**
     * Jestli se aktivni
     * @var boolean
     */
    protected $active;
    /**
     * @var array Role role tohoto uzivatele
     */
    protected $roles = [];
    /**
     * @var array UserAditionalInfo dalsi informace pripojene k tomuto uzivateli
     */
    protected $userAditionalInfos = [];
    /**
     * @var array UserExternalLogin externi prihlaseni
     */
    protected $userExternalLogins = [];

    public static function __lastLoginDate()
    {
        return dateTimeField(['notNull' => false]);
    }

    public static function __roles()
    {
        return transientField();
    }

    public static function __userAditionalInfos()
    {
        return transientField();
    }

    public static function __userExternalLogins()
    {
        return transientField();
    }


    // generovane gettery a settery
    public function getId()
    {
        return $this->id;
    }

    public function setId($id)
    {
        $this->id = $id;
    }

    public function getLogin()
    {
        return $this->login;
    }

    public function setLogin($login)
    {
        $this->login = $login;
    }

    public function getPassword()
    {
        return $this->password;
    }

    public function setPassword($password)
    {
        $this->password = $password;
    }

    public function getEmail()
    {
        return $this->email;
    }

    public function setEmail($email)
    {
        $this->email = $email;
    }

    public function getActive()
    {
        return $this->active;
    }

    public function setActive($active)
    {
        $this->active = $active;
    }

    public function getName()
    {
        return $this->name;
    }

    public function setName($name)
    {
        $this->name = $name;
    }

    public function getRegistrationDate()
    {
        return $this->registrationDate;
    }

    public function setRegistrationDate(Date $registrationDate)
    {
        $this->registrationDate = $registrationDate;
    }

    public function getLastLoginDate()
    {
        return $this->lastLoginDate;
    }

    public function setLastLoginDate(Date $lastLoginDate)
    {
        $this->lastLoginDate = $lastLoginDate;
    }

    public function getUserExternalLogins()
    {
        return $this->userExternalLogins;
    }

    public function setUserExternalLogins(array $userExternalLogins)
    {
        $this->userExternalLogins = $userExternalLogins;
    }

    public function addUserExternalLogin(UserExternalLogin $userExternalLogin)
    {
        $this->userExternalLogins[] = $userExternalLogin;
    }

    public function getRoles()
    {
        return $this->roles;
    }

    public function setRoles(array $roles)
    {
        $this->roles = $roles;
    }

    public function getUserAditionalInfos()
    {
        return $this->userAditionalInfos;
    }

    public function setUserAditionalInfos(array $userAditionalInfos)
    {
        $this->userAditionalInfos = $userAditionalInfos;
    }
}
