<?php

namespace IZON\Users\DB;

use IZON\DB\QueryHelpers;
use IZON\Users\Domain\UserRole;

return [
    'findUserByLogin_1' => [
        'queryFactory' => function (QueryHelpers $queryHelpers) {
            return 'select ' . $queryHelpers->getClassProperties("u")
                . ' from ' . $queryHelpers->getTableName("u")
                . ' where ' . $queryHelpers->getColumnName("login") . " = :arg0  limit :maxResults offset :firstResult";
        }
    ],

    'findUsersByRole_1' => [
        'queryFactory' => function (QueryHelpers $queryHelpers) {
            return "select " . $queryHelpers->getClassProperties("a")
                . " from " . $queryHelpers->getTableName("a")
                . " join " . $queryHelpers->getClassTableName(UserRole::class, "b")
                . " on " . $queryHelpers->getColumnName("id", "a") . " = " . $queryHelpers->getClassColumnName(UserRole::class, "fkRoleId", "b")
                . " where " . $queryHelpers->getClassColumnName(UserRole::class, "fkUserId", "b") . " = :arg0"
                . " limit :maxResults offset :firstResult";
        }
    ]
];
