<?php

namespace IZON\Users\DB\Paginators\UserDao;

use Exception;

use IZON\DB\QueryHelpers;
use IZON\DB\OrderBy;

use IZON\DB\Paginator\PaginatorConfig;

return [
    // nastaveni defaultniho paginatoru
    // defaultuje retezce, aby se porovnavaly like a obaluje hotnotu parametru % . $value . %
    // defaultuje zbytek, aby se porovnaval =
    // pokud je hodnota rovna NULL a sloupecek je nullable tak se vklada is NULL
    PaginatorConfig::DEFAULT_PAGINATOR_NAME => [
        // slouzi k predefinovani tpho jak se ma hovat k jednotlivym polim  
        "properyDefinitions" => [
            "lastName" => [
                "valuePrefix" => "%", // prefix pro hodnotu, do torazu se potom posila $valuePrefix . $value . $valueSufix
                "valueSufix" => "%", // suffix pro hodnotu
            ],
            "login" => [
                "valuePrefix" => "", // prefix pro hodnotu, do torazu se potom posila $valuePrefix . $value . $valueSufix
                "valueSufix" => "%", // suffix pro hodnotu
            ],
            "active" => [
                
            ]
        ],
        "excludedProperties" => [], // jake property se menaji do dotazu zahrnovat
        "excludedOrders" => [], // podle kterych property se da radit, podud neni urceno jinak tak podle vsech
        "defaultOrder" => ["id", OrderBy::DESC] // defaultni razeni co se ma pouzit, pokud neni zadano tak podle id desc
    ],
    
];
        